/*:
 * @target MZ
 * @plugindesc 画面クリック時にSEを再生するプラグイン。指定スイッチでオンオフ制御可。音量も調整可能。@ChatGPT
 * @author ChatGPT
 *
 * @param enableSwitchId
 * @type switch
 * @text 有効スイッチID
 * @desc このスイッチがONのときだけクリックSEが再生されます。
 *
 * @param seName
 * @type file
 * @dir audio/se
 * @text 再生するSE
 * @desc クリック時に再生するSEファイル名
 *
 * @param seVolume
 * @type number
 * @max 100
 * @min 0
 * @default 90
 * @text SE音量
 * @desc 再生するSEの音量（0〜100）
 *
 * @param sePitch
 * @type number
 * @min 50
 * @max 150
 * @default 100
 * @text SEピッチ
 * @desc 再生するSEのピッチ（50〜150）
 *
 * @param sePan
 * @type number
 * @min -100
 * @max 100
 * @default 0
 * @text SEパン
 * @desc 再生するSEの定位（左-100〜右+100）
 *
 * @help
 * 【概要】
 * このプラグインを導入すると、画面クリック時に指定したSEが再生されます。
 *
 * 再生は、指定スイッチがONのときだけ行われます。
 *
 * 【設定方法】
 * プラグインパラメータから以下を設定してください：
 * - 有効スイッチID：スイッチがONのときだけ有効になります。
 * - SEファイル名：audio/se フォルダ内のSE名
 * - 音量 / ピッチ / パン：必要に応じて調整可能
 *
 * 【注意】
 * タイトル画面・メニュー・マップ画面などすべての場面で動作します。
 */

(() => {
    const params = PluginManager.parameters("ClickSoundEffect");

    const enableSwitchId = Number(params["enableSwitchId"] || 0);
    const seName = String(params["seName"] || "");
    const seVolume = Number(params["seVolume"] || 90);
    const sePitch = Number(params["sePitch"] || 100);
    const sePan = Number(params["sePan"] || 0);

    if (enableSwitchId > 0 && seName) {
        const _SceneManager_updateMain = SceneManager.updateMain;
        SceneManager.updateMain = function() {
            _SceneManager_updateMain.call(this);
            if (TouchInput.isTriggered() && $gameSwitches.value(enableSwitchId)) {
                AudioManager.playSe({
                    name: seName,
                    volume: seVolume,
                    pitch: sePitch,
                    pan: sePan
                });
            }
        };
    }
})();
